<?php
	include_once dirname(__FILE__).'/shop.class.php';

	$shopobj=new shop();

	function shop_typename($typeid=0)
	{
		global $shopobj;
		return $shopobj->typename(intval($typeid));
	}

	function formatshopurl($id,$is_rewrite=1,$preview=0)
	{
		global $shopobj;
		return $shopobj->formatshopurl($id,$is_rewrite,$preview);
	}

	function parse_shop_template($str)
	{
		$str=preg_replace('/\{niubi:shop\s+([^\}]+)\}/ie',"la_call_user_func('get_shop_tag','\\1')",$str);
		$str=preg_replace('/\{\/niubi:shop\}/i',"<?php }unset(\$_DATA); ?>",$str);  
		
		$str=preg_replace('/\{niubi:shoptype\s+([^\}]+)\}/ie',"la_call_user_func('get_shoptype_tag','\\1')",$str);
		$str=preg_replace('/\{\/niubi:shoptype\}/i',"<?php }unset(\$_DATA); ?>",$str); 
		return $str;
	}

	function get_shoptype_tag($para)
	{
		/*
			Ĭϲ
		*/
		$args=array('parentid'=>'0',
					'limit'=>'0',
					'row'=>'16');
		foreach($para as $key => $arg)
		{
			if(isset($args[$key]))
			{
				$args[$key]=$arg;
			}
		}
		
		extract($args);
		
		$mod=!$mod?0:array_map('intval',explode(',',$mod));
		$row=intval($row)>0?intval($row):10;
		return '<?php $_DATA=get_shoptype_data('.$parentid.','.$limit.','.$row.');foreach($_DATA as $no => $r)if(is_array($r)){?>';
	}

	function get_shoptype_data($parentid,$limit,$row)
	{
		global $cacheobj,$db,$siteidobj,$bbsobj;
	
		$result=$_DATA=array();
		$limit=intval($limit)?intval($limit):0;
		$row=intval($row)?intval($row):16;
		$parentid=intval($parentid)?intval($parentid):0;

		if(SITETYPE && $_SESSION['siteid'])
		{
			$where='siteid IN('.implode(',',$siteidobj->getchildid($_SESSION['siteid'])).')';
		}
		else
		{
			$where='1';
		}

		
		$where.=$parentid?' AND parentid='.intval($parentid):'';
		
		$sql="SELECT * FROM `".LA_PRE."shop_type` WHERE $where ORDER BY `".LA_PRE."shop_type`.`orderby` DESC LIMIT $limit,$row";

		$data=$cacheobj->get($sql);
		if(!$data)
		{
			$data=$db->fetch_all($sql);
			if($data)
			{
				$cacheobj->set($sql,$data);
			}
		}
		return $data;
	}

	function get_shop_tag($para)
	{
		/*
			Ĭϲ
		*/
		$args=array('typeid'=>'0',
					'limit'=>'0',
					'row'=>'16',
					'istop'=>'-1',
					'userid'=>'0',
					'withthumb'=>'0');
		foreach($para as $key => $arg)
		{
			if(isset($args[$key]))
			{
				$args[$key]=$arg;
			}
		}
		
		extract($args);
		
		$mod=!$mod?0:array_map('intval',explode(',',$mod));
		$row=intval($row)>0?intval($row):10;
		return '<?php $_DATA=get_shop_data('.$typeid.','.$limit.','.$row.','.$istop.','.$userid.','.$withthumb.');foreach($_DATA as $no => $r)if(is_array($r)){?>';
	}

	function get_shop_data($typeid,$limit,$row,$istop,$userid,$withthumb)
	{
		global $cacheobj,$db,$siteidobj,$shopobj;
	
		$result=$_DATA=array();
		$limit=intval($limit)?intval($limit):0;
		$row=intval($row)?intval($row):16;
		$userid=intval($userid)?intval($userid):0;
		$istop=intval($istop)>-1?intval($istop):-1;

		if(SITETYPE && $_SESSION['siteid'])
		{
			$where='siteid IN('.implode(',',$siteidobj->getchildid($_SESSION['siteid'])).') AND status=1';
		}
		else
		{
			$where='status=1';
		}

		if($istop==-1)
		{
			$where.='';
		}
		else if($istop==0)
		{
			$where.=' AND (istop='.intval($istop).' OR istop<'.TIME.')';
		}
		else
		{
			$where.=' AND istop>='.TIME;
		}
		
		$where.=$userid?' AND userid='.intval($userid):'';

		$where.=$typeid?' AND typeid IN('.implode(',',$shopobj->typesqlids($typeid)).')':'';

		$where.=$withthumb?' AND thumb!=\'\'':'';
		
		$sql="SELECT * FROM `".LA_PRE."shop` WHERE $where ORDER BY `".LA_PRE."shop`.`updatetime` DESC LIMIT $limit,$row";

		$data=$cacheobj->get($sql);
		if(!$data)
		{
			$data=$db->fetch_all($sql);
			if($data)
			{
				$cacheobj->set($sql,$data);
			}
		}
		return $data;
	}
?>
